package gov.va.med.domain.persistence.util;

import gov.va.med.mhv.rxrefill.data.model.Function;
import gov.va.med.mhv.rxrefill.data.repository.FunctionRepository;
import gov.va.med.mhv.rxrefill.exception.MHVRuntimeException;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author PII
 * @version $Id: FunctionLookup.java,v 1.4 2005/08/09 13:45:25 ed.brundage Exp $
 * @since MHV 2.0 <br>04/27/2005
 */
@Component
public class FunctionLookup {

	private static Logger log = LogManager.getLogger(FunctionLookup.class);

	private static HashMap<String, Function> mapById = new HashMap();
	private static FunctionLookup instance = null;
	private static long lastLoadTime;
	private static final long REFRESH_INTERVAL_MILLIS = 600000;

	@Autowired
	private FunctionRepository functionRepository;

	//loading FunctionLookup using Spring IOC
	/*protected FunctionLookup() {
		super();
		load();
	}*/

	public void load() {
		synchronized(mapById) {
			/*FunctionDAO dao = (FunctionDAO)ObjectFactory.getBean(MessagingConstants.FUNCTION_DAO_BEAN_NAME);
			List list = dao.listAll();
			Iterator iter = list.iterator();
			mapById = new HashMap();
			while(iter.hasNext()) {
				Function function = (Function)iter.next();
				mapById.put(function.getFunctionName(), function);
			}*/

			mapById = new HashMap<String, Function>();

			List<gov.va.med.mhv.rxrefill.data.model.Function> functionList = null;
			try {
				functionList = functionRepository.findAll();
			} catch(Exception e) {
				log.error("Error in fetching values from FUNCTIONS table", e);
				throw new MHVRuntimeException("Error in fetching values from FUNCTIONS table", e);
			}

			if (null != functionList && functionList.size() > 0) {
				for(Function function : functionList) {
					mapById.put(function.getFunctionName(), function);
				}
			}

			lastLoadTime = System.currentTimeMillis();
		}
	}

	public static FunctionLookup getInstance() {
		if(instance == null) {
			instance = new FunctionLookup();
		}

        // Temporary code until a better way is found to refresh without bouncing the server.
	    synchronized (FunctionLookup.class)
	    {
	        if (System.currentTimeMillis() - lastLoadTime > REFRESH_INTERVAL_MILLIS) {
	            instance.load();
	        }
	    }
		return instance;
	}

	public Function getById(String functionName) {
		return (Function) mapById.get(functionName);
	}

	public Collection getAll() {
		return mapById.values();
	}

	public List getByCategoryId(String categoryId) {
		ArrayList result = new ArrayList();
		Iterator iterator = getAll().iterator();
		while(iterator.hasNext()) {
			Function tmp = (Function)iterator.next();
			if(((String)tmp.getCategoryType().getId()).equals(categoryId))
				result.add(tmp);
		}
		return result;
	}

	public Long getIdByFunctionName(String functionName) {
		Long result = null;
		Iterator iterator = getAll().iterator();
		while (iterator.hasNext()) {
			Function tmp = (Function) iterator.next();
			if(tmp.getFunctionName().equals(functionName))
				if (tmp.getId() != null &&
				tmp.getId() instanceof Long) {
					result = (Long) tmp.getId();
					break;
				}
		}
		return result;
	}

}
